<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class BlockReasonResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            "id" => $this->id,
            "company_id" => $this->company_id,
            "name" => $this->dropdown_name,
            'name_ar' => $this->getTranslations('dropdown_name')['ar'],
            'name_en' => $this->getTranslations('dropdown_name')['en'],
        ];
    }
}
