<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class BlockSupplierResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'supplier_id' => $this->supplier_id,
            'name' => $this->whenLoaded('supplier', function () {
                return $this->supplier->name;
            }),
            'block_reason' => BlockReasonResource::make($this->whenLoaded('blockReason')),
            'date' => $this->date,
            'note' => $this->note,
        ];
    }
}
