<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BrancUnithResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'selling_price' => $this->selling_price,
            'purchasing_price' => $this->purchasing_price,
            // 'unit' => UnitResource::make($this->whenLoaded('unit')),
            'unit_id' => $this->whenLoaded('unit', fn () => $this->unit->id),
            'unit_name' => $this->whenLoaded('unit', fn () => $this->unit->name),
        ];
    }
}
