<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class CompanyPackageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $package =  $this->companyCurrentPackageWithFeatures();
        $subs =  $this->lastSubscription();

        return [
            'id' => $this->id,
            'name' => $this->name,
            'email' => $this->email,
            'phone' => $this->phone,
            'logo' => $this->logo,
            'email_verified_at' => $this->email_verified_at,
            'lang' => $this->lang,
            'package_id' => $package ? $package->id : null,
            'package_name' => $package ? $package->name : null,
            'remaining_days' => $subs?  Carbon::now()->diffInDays(Carbon::parse($subs->end_date), false) : null,
        ];
    }
}
