<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CompanySystemSettingsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'value' => $this->value,
            'content' => $this->when(($this->type =="printing"), $this->content),
            'system_setting_group' => $this->whenLoaded('systemSettingGroup', function () {
                return $this->systemSettingGroup->name;
            }),
            'sub_group' => $this->sub_group,
            'system_setting' => new SystemSettingsResource($this->whenLoaded('settings'))
        ];
    }
}
