<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CustodyResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'account' =>  new AccountResource($this->whenLoaded('account')),
            'employee' => new EmployeeResource($this->whenLoaded('employee')),
            'status' => $this->status,
            'note' => $this->note,
            'custodiesTaken' => CustodyTakenResource::collection($this->whenLoaded('custodiesTaken.journals.entries')),
        ];
    }
}
