<?php

namespace App\Http\Resources;

use App\Models\Client;
use App\Models\Supplier;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Resources\Json\JsonResource;

class EntryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'status' => $this->status,
            'amount' => (string) number_format($this->amount, 2),
            'old_account_amount' => (string) number_format($this->old_account_amount, 2),
            'created_at' => $this->created_at,
            'type' => $this->whenLoaded('type', function () {
                $resourceClass = app($this->type_type)->resolveResource();
                return new $resourceClass($this->type);
            }),
            'ref_type' => $this->whenLoaded('type', function () {
                return self::getRefTypeFromModel($this->type);
            }),
            'journal' => JournalResource::make($this->whenLoaded('journal')),
            'account' => new AccountResource($this->whenLoaded('account')),
            'note' => $this->note,
            'order' => $this->order,
        ];
    }


    private  static function  getRefTypeFromModel(Model $model)
    {
        switch ($model) {
            case $model instanceof Client:
                return 'client';
            case $model instanceof Supplier:
                return 'supplier';
            default:
                return null;
        }
    }
}
