<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ExpenseResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'name_ar' => optional($this->getTranslations('name'))['ar'],
            'name_en' => optional($this->getTranslations('name'))['en'],
            'account' => AccountResource::make($this->whenLoaded('account')),
        ];
    }
}
