<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class LocationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
             'name_ar' => $this->getTranslations('name')['ar'] ?? '',
            'name_en' => $this->getTranslations('name')['en'] ?? '',
            'code' => $this->code,
            'children' =>  LocationResource::collection($this->whenLoaded('children')),
            'city' =>  LocationResource::make($this->whenLoaded('city')),
            'country' =>  LocationResource::make($this->whenLoaded('country')),
        ];
    }
}
