<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MerchantRevenuesResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'code' => $this->code,
            'date' => $this->date,
            'client_name' => $this->client_name,
            'phone' => $this->phone,
            'city' => $this->city,
            'network' => $this->network,
            'cash' => $this->cash,
            'transfer' => $this->transfer,
            'electronic' => $this->electronic,
            'wallet' => $this->wallet,
            'tap' => $this->tap,
            'stc' => $this->stc,
            'mada' => $this->mada,
            'total' => $this->total,
            'total_merchant_receivables' => $this->total_merchant_receivables,
            'total_company_profits' => $this->total_company_profits,
        ];
    }
}
