<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class NetworkResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'name_ar' => $this->getTranslations('name')['ar'] ?? '',
            'name_en' => $this->getTranslations('name')['en'] ?? '',
            'status' => $this->status,
            'branch' => BranchResource::make($this->whenLoaded('branch')),
            'account' => AccountResource::make($this->whenLoaded('account')),
        ];
    }
}
