<?php

namespace App\Http\Resources;

use App\Http\Requests\Api\Admin\Location\LocationRequest;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PaymentDataResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'currency' => new CurrencyResource($this->whenLoaded('currency')),
            'country' => new LocationResource($this->whenLoaded('country')),
            'bank_name' => $this->bank_name,
            'owner_name' => $this->bank_account_owner_name,
            'account_number' => $this->account_number,
            'iban_code' => $this->iban_code,
            'swift_code' => $this->swift_code,
            'bank_address' => $this->bank_address
        ];
    }
}
