<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Helper\CompanyHelper;

class RoleResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'is_empty' => $this->permissions->count() == 0 ? true : false,
            // 'permissions' => new PermissionResource($this->whenLoaded('permissions')),
            'permissions' => $this->permissions,
        ];
    }
}
