<?php

namespace App\Http\Resources;

use App\Models\Setting;
use Illuminate\Http\Request;
use App\Http\Enums\Setting\SettingTypeEnum;
use Illuminate\Http\Resources\Json\JsonResource;

class SettingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'label' => $this->label,
            'key' => $this->key,
            'value' => $this->type == SettingTypeEnum::FILE ? asset('public/' . Setting::UPLOADED_FILES . '/' . $this->value) : $this->value,
            'type' => $this->type->name,
        ];
    }
}
