<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ShiftResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'start_amount' => $this->start_amount,
            'end_amount' => $this->end_amount,
            'open_name' => $this->open_name,
            'close_name' => $this->close_name,
            'status' => is_null($this->close_name),
            'auto' => !is_null($this->auto_shift_id),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'auto_shift' => AutoShiftResource::make($this->whenLoaded('autoShift')),
             'branch' => $this->branch ? [
                'id' => $this->branch->id,
                'name' => $this->branch->name,
            ] : null, // Only include id and name of branch
            'treasury' => TreasuryResource::make($this->whenLoaded('treasury')),
            'employee' => $this->employee ? [
                'id' => $this->employee->id,
                'name' => $this->employee->name,
            ] : null, // Only include id and name of employee
            'journals' => JournalResource::collection($this->whenLoaded('journals')),
        ];
    }
}
