<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ShipmentTypeResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'convert_value' => $this->convert_value,
            'weight' => $this->weight,
            'main_price' => $this->main_price,
            'price_per_kg' => $this->price_per_kg,
            'location_id' => $this->location->id ?? "",
            'parent_id' => $this->location->parent_id ?? "",
        ];
    }
}
