<?php

namespace App\Http\Services\Account;

use App\Models\Branch;
use App\Models\Account;
use App\Models\Journal;
use App\Models\Product;
use App\Models\Warehouse;
use App\Models\ProductWarehouse;
use App\Http\Helper\AccountHelper;

class OpenBalanceJournalService
{
    public static function createJournal(
        float $total,
        Product $product,
        ProductWarehouse $productWarehouse,
        Account $account,
        $date = null,
        ?Branch $branch = null,
        ?Warehouse $warehouse = null,
        $status
    ): Journal {

        $journal = JournalService::createJournal(
            date: $date ?? now(),
            type: __('constants.journal_open_balance_type'),
            source: "Open Balance",
            description: __('constants.open_balance_description'),
            file: null,
            employee: null,
            status: $status,
            debit: self::debitSide(account: $account, productWarehouse: $productWarehouse, total: $total),
            credit: self::creditSide(product: $product, total: $total),
            journalable: $productWarehouse,
            branch: $branch ?? null,
            warehouse: $warehouse ?? null,
        );

        return $journal;
    }

    private static function debitSide(Account $account, ProductWarehouse $productWarehouse, float $total): array
    {
        return [
            [
                'account' => $account,
                'type' => [
                    'type' => ProductWarehouse::class,
                    'id' => $productWarehouse->id,
                ],
                'amount' => $total,
                'entry_type' => "credit",
            ],
        ];
    }

    private static function creditSide(Product $product, float $total): array
    {
        return [
            [
                'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_OPEN_BALANCE, 'Inventory'),
                'type' => [
                    'type' => Product::class,
                    'id' => $product->id,
                ],
                'amount' => $total,
                'entry_type' => "debit",
            ],
        ];
    }
}
