<?php

namespace App\Http\Services\Custody;

use App\Models\Branch;
use App\Models\Account;
use App\Models\Custody;
use App\Models\Warehouse;
use App\Models\CustodyTaken;
use App\Http\Services\Account\JournalService;
use Illuminate\Support\Facades\DB;

class CustodyService
{
    public static function create(array $data): CustodyTaken
    {

        return DB::transaction(function () use ($data) {
             //create the taken custody
            $custodyTaken = CustodyTaken::create($data);
            //create the journal
            self::createCustodyJournals(
                data: $data,
                custodyTaken: $custodyTaken,
                branch: Branch::findOrFail($data['branch_id']),
            );
            return $custodyTaken;
        });
    }

    private static function createCustodyJournals($data,CustodyTaken $custodyTaken,Branch $branch,) {
        $entries = $data['type'] == 'deposit' ? self::depositSides($data) : self::withdrawSides($data);

        JournalService::createJournal(
            date: now(),
            type: __('constants.auto_type'),
            source: 'Custody',
            description: __('messages.custody_taken_journal'),
            file: null,
            employee: null,
            status: true,
            debit: $entries['debit'],
            credit: $entries['credit'],
            branch: $branch ?? null,
            warehouse: null,
            journalable: $custodyTaken
        );
    }

    private static function withdrawSides(array $data): array
    {
        $entries = [];

        $entries['debit'][] =
            [
                'account' => Custody::where('employee_id', $data['employee_id'])->first()->account,
                'type' => [
                    'type' => null,
                    'id' => null,
                ],
                'amount' => $data['amount'],
                'entry_type' => "debit",
            ];

        $entries['credit'][] =
            [
                'account' => Account::findOrFail($data['account_id']),
                'type' => [
                    'type' => null,
                    'id' => null,
                ],
                'amount' => $data['amount'],
                'entry_type' => "credit",
            ];

        return  $entries;
    }

    private static function depositSides(array $data): array
    {
        $entries = [];
        $entries['credit'][] =
            [
                'account' => Custody::where('employee_id', $data['employee_id'])->first()->account,
                'type' => [
                    'type' => null,
                    'id' => null,
                ],
                'amount' => $data['amount'],
                'entry_type' => "credit",
            ];

        $entries['debit'][] =
            [
                'account' => Account::findOrFail($data['account_id']),
                'type' => [
                    'type' => null,
                    'id' => null,
                ],
                'amount' => $data['amount'],
                'entry_type' => "debit",
            ];

        return  $entries;
    }
}
