<?php

namespace App\Http\Services;

use App\Models\Product;
use App\Trait\ProductTrait;
use App\Trait\UploadFileTrait;
use Illuminate\Support\Facades\DB;

class ProductService
{
    use UploadFileTrait, ProductTrait;

    public function create($request): Product
    {
        return DB::transaction(function () use ($request) {
            // Create the product
            $product = $this->createProductDetails($request->validated()['product_details']);
            $this->handleProductUnitsAndWarehouses($request, $product);

            return $product;
        });
    }

    public function update($request, Product $product): Product
    {
        $validatedProductData = $request->validated()['product_details'];
        if (!isset($validatedProductData['tax_id'])) {
            $validatedProductData['tax_id'] = null;
        }
        if (!isset($validatedProductData['image'])) {
            $validatedProductData['image'] = null;
        }
        return DB::transaction(function () use ($request, $product, $validatedProductData) {
            // Update the product details
            $this->updateProductDetails($product, $validatedProductData);

            $this->handleProductUnitsAndWarehouses($request, $product);

            return $product;
        });
    }
}
