<?php

namespace App\Http\Services;

use App\Http\Services\Account\JournalService;
use App\Models\Company;
use App\Models\Account;
use Illuminate\Support\Facades\DB;

class RevenuesService
{

    public  static function create($request, $model)
    {
        DB::beginTransaction();
        $company_id = self::getCompanyIdFromSecretKey($request->header('api-key'));

        foreach ($request->data as $revenue) {
            //Get Accounts From Data
            $creditAccount = $revenue['credit_account'];
            $debitAccounts = $revenue['debit_accounts'];

            // Remove Accounts from Data to store revenue
            unset($revenue['credit_account']);
            unset($revenue['debit_accounts']);

            //Add company id to revenue
            $revenue['company_id'] = $company_id;


            $model::create($revenue);
            //pass accounts to store the journal and entries

            $entries = self::getJournalEntries($creditAccount, $debitAccounts, $company_id);
            self::createJournal($entries);
        }
        DB::commit();
    }




    private static function createJournal(array $entries)
    {
        JournalService::createJournal(
            date: now(),
            type: __('constants.auto_type'),
            source: 'Revenues',
            description: null,
            file: null,
            employee: null,
            status: true,
            debit: $entries['debit'],
            credit: $entries['credit'],
            journalable: null,
            branch: $branch ?? null,
            warehouse: $warehouse ?? null,
        );
    }
    private  static function getJournalEntries($creditAccount, $debitAccounts, $company_id): array
    {
        $entries = [];
        $creditEntry = self::getAccountFromName($creditAccount['name'], $company_id);
        $entries['credit'][] =
            [
                'account' => $creditEntry,
                'type' => [
                    'type' => null,
                    'id' => null,
                ],
                'amount' => $creditAccount['amount'],
                'entry_type' => "credit",
            ];

        foreach ($debitAccounts as $debitAccount) {
            $debitEntry = self::getAccountFromName($debitAccount['name'], $company_id);
            $entries['debit'][] =
                [
                    'account' => $debitEntry,
                    'type' => [
                        'type' => null,
                        'id' => null
                    ],
                    'amount' => $debitAccount['amount'],
                    'entry_type' => "debit",
                ];
        }

        return $entries;
    }


    private static  function getAccountFromName($accountName, $company_id)
    {
        return Account::where('name->ar', $accountName)->where('company_id', $company_id)->first();
    }


    private  static function  getCompanyIdFromSecretKey($secretKey)
    {
        return Company::where('secret_key', $secretKey)->first()->id;
    }
}
