<?php

namespace App\Http\Services;

use App\Http\Helper\CompanyHelper;
use App\Models\Service;


class ServiceService
{
    public function create($data)
    {
        $service = $this->createService($data);

        if (isset($data['pricing']) && $data['pricing'] !== false) {
            $this->pricing($service, $data['pricing']);
        }

        if (isset($data['products']) && $data['products'] !== false) {
            $this->addProducts($service, $data['products']);
        }

        if (isset($data['branches']) && $data['branches'] !== false) {
            $this->addToBranches($service, $data['branches']);
        }

        return $service;
    }

    public function createService($data)
    {
        return Service::create(
            [
                'company_id' => CompanyHelper::getId(),
                'code' => self::generateUniqueCode()
            ]
                + $data
        );
    }

    public function update($service, $data)
    {
        $service->update($data);

        if (isset($data['pricing']) && $data['pricing'] !== false) {
            $this->pricing($service, $data['pricing']);
        }

        if (isset($data['products']) && $data['products'] !== false) {
            $this->updateProducts($service, $data['products']);
        }

        if (isset($data['branches']) && $data['branches'] !== false) {
            $this->updateBranches($service, $data['branches']);
        }

        return $service;
    }

    public function pricing($service, $data)
    {
        $service->update($data);
        return $service;
    }

    public function addProducts($service, $data)
    {
        foreach ($data as $products) {
            $service->productServiceUnits()->create($products);
        }
        return $service;
    }

    public function addToBranches($service, $data)
    {
        foreach ($data as $branch) {
            $service->branches()->create($branch);
        }
        return $service;
    }

    public function updateProducts($service, $data)
    {
        $productsIdsToUpdate = [];
        foreach ($data as $productUnitData) {
            $product_unit = $service
                ->productServiceUnits()
                ->where('product_id', $productUnitData['product_id'])
                ->where('company_unit_id', $productUnitData['company_unit_id'])
                ->first();

            if ($product_unit) {
                // Update the existing warehouse
                $product_unit->update($productUnitData);
                $productsIdsToUpdate[] = $product_unit->id;
            } else {
                // Create a new warehouse
                $product_unit = $service->productServiceUnits()->create($productUnitData);
                $productsIdsToUpdate[] = $product_unit->id;
            }
        }

        // Delete warehouses that were not included in the update
        $service->productServiceUnits()->whereNotIn('id', $productsIdsToUpdate)->delete();
    }

    public function updateBranches($service, $data)
    {
        $branchesIdsToUpdate = [];
        foreach ($data as $branchData) {

            $branchService = $service
                ->branches()
                ->where('service_id', $service->id)
                ->where('branch_id', $branchData['branch_id'])
                ->first();

            if ($branchService) {
                // Update the existing warehouse
                $branchService->update($branchData);
                $branchesIdsToUpdate[] = $branchService->id;
            } else {
                // Create a new warehouse
                $branchService = $service->branches()->create($branchData);
                $branchesIdsToUpdate[] = $branchService->id;
            }
        }

        // Delete warehouses that were not included in the update
        $service->branches()->whereNotIn('id', $branchesIdsToUpdate)->delete();
    }

    public static function generateUniqueCode()
    {
        $code = mt_rand(100000, 999999);

        while (Service::where('code', $code)->exists()) {
            $code = mt_rand(100000, 999999);
        }

        return $code;
    }
}
