<?php

namespace App\Http\Services\Subscription;

use App\Models\Company;
use App\Models\Package;
use App\Jobs\MakeSubscription;


class SubscriptionService
{
    public static function handleFreePackageSubscription(Company $company): ?string
    {
        $freePackage = Package::freePackage();

        if ($freePackage) {
            self::handlePackageSubscription(company: $company, package: $freePackage);
        } else {
            return __('messages.no_free_package_available');
        }

        return null;
    }

    public static function handlePackageSubscription(Company $company, Package $package): void
    {
        MakeSubscription::dispatch(
            package: $package,
            company: $company
        );

        return;
    }
}
