<?php

namespace App\Http\Services\Worker;

use App\Models\Worker;
use Laravel\Sanctum\PersonalAccessToken;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class ShiftPermissionAfterLogin
{



    public static function addPermissionToWorker(Worker $worker, $shift, $autoShift): void
    {
        if ($autoShift || $shift) {
            if ($worker->cannot('create shifts')) {
                $worker->givePermissionTo('create shifts');
            }
            if ($worker->cannot('edit shifts')) {
                $worker->givePermissionTo('edit shifts');
            }
        }
    }
    public static function removePermissionFromWorker(): void
    {
         
        if (auth('worker')->check()) {
     
            $worker = auth('worker')->user();
            $lastToken = PersonalAccessToken::where('tokenable_type', 'App\Models\Worker')
                ->where('tokenable_id', $worker->id)
                ->latest('created_at')
                ->first();

            $lastTokenCreatedAt = $lastToken->created_at;

            $permissionAssignments = DB::table('model_has_permissions')
                ->where('model_type', 'App\Models\Worker')
                ->where('model_id', $worker->id)
                ->get();



$cutoffTime = Carbon::parse($lastTokenCreatedAt)->subHours(4);

// Iterate over each permission assignment
foreach ($permissionAssignments as $permissionAssignment) {
    $permissionAssignmentCreatedAt = Carbon::parse($permissionAssignment->created_at);
    
    // Check if the permission assignment was created before the cutoff time
    if ($permissionAssignmentCreatedAt->lte($cutoffTime)) {
        // Remove the permission assignment
        DB::table('model_has_permissions')
            ->where('model_type', 'App\Models\Worker')
            ->where('model_id', $worker->id)
            ->where('permission_id', $permissionAssignment->permission_id)
            ->delete();
    }
}
    
        //     dd($permissionAssignments);
        //     foreach ($permissionAssignments as $permissionAssignment) {
            
        //         $permissionAssignmentCreatedAt = Carbon::parse($permissionAssignment->created_at);
                
        //         if ($permissionAssignmentCreatedAt->lte($lastTokenCreatedAt->subHours(4))) {
                    
        //             // Remove the permission
                  
        //             DB::table('model_has_permissions')
        //                 ->where('model_type', 'App\Models\Worker')
        //                 ->where('model_id', $worker->id)
        //                 ->where('permission_id', $permissionAssignment->permission_id)
        //                 ->delete();
        //         }
        //     }
        }
      
    }
}
