<?php

namespace App\Imports;

use App\Http\Helper\CompanyHelper;
use App\Models\Client;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\ValidationException;

class ClientsImport implements ToModel, WithHeadingRow
{
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)

    {
        $validator = Validator::make($row, [
            'name' => 'required',
            'phone' => 'required',
        ]);

        if ($validator->fails()) {
            throw new ValidationException($validator);
        }
        if (Client::where('phone', $row['phone'])->first()) {
            return null;
        }
        return new Client([
            'name' => $row['name'],
            'phone' => $row['phone'],
            'company_id' => CompanyHelper::getId(),
        ]);
    }
}
