<?php

namespace App\Jobs;

use Carbon\Carbon;
use App\Models\Company;
use App\Models\Package;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use App\Http\Enums\Subscription\PaymentStatusEnum;

class MakeSubscription implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct(
        public Package $package,
        public Company $company
    ) {
        //
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $this->disableAllSubscriptions()
            ->createNewSubscription();
    }

    private function disableAllSubscriptions(): self
    {
        $this->company->subscriptions()->update(['status' => false]);
        return $this;
    }

    private function createNewSubscription(): self
    {
        $this->company->subscriptions()->create(
            [
                'package_id' => $this->package->id,
                'start_date' => now(),
                'end_date' => $this->calcEndDate(),
                'status' => true,
                'price' => $this->package->price,
                'payment_status' => PaymentStatusEnum::payment_accepted,
                'payment_reference_id' => 'payment_reference',
            ]
        );
        return $this;
    }

    private function calcEndDate()
    {
        return Carbon::now()->addDays($this->package->period);
    }
}
