<?php

namespace App\Listeners;

use App\Events\JournalRepeationExpiration;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Carbon\Carbon;
use App\Models\JournalReptation;
class UpdateExpirationStatus
{
    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(JournalRepeationExpiration $event): void
    {
       $today = Carbon::today();

        // Find all journals where end_date is less than today and status is not yet updated
        $journals = JournalReptation::where('end_date', '<', $today)
                            ->where('is_expired', '!=', 1) // Assuming 'completed' is your final status
                            ->get();

        // Update the status of each journal
        foreach ($journals as $journal) {
            $journal->update(['is_expired' =>1]);
        }
    }
}
