<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;

class AppInformation extends Model
{
    use HasFactory, HasTranslations;

    const UPLOADED_FILES = 'uploads/app';
    protected $table = 'app_information';
    protected $guarded = [];

    protected $fillable = [
        'company_id',
        'employee_id',
        'file',
        'type',
        'title',
        'content',
        'section_id',
    ];

    public $translatable = ['content', 'title'];

    public function getFileAttribute($value)
    {
        return asset('public/' . AppInformation::UPLOADED_FILES . "/" . $value);
    }
}
