<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Attendance extends Model
{
    use HasFactory;
    protected $guarded = [];
    const UPLOADED_FILES = 'uploads/app/attendance';
    public function getImageAttribute($value)
    {
        return asset('public/' . Attendance::UPLOADED_FILES . "/" . $value);
    }
    
     public function employee(){
        return $this->belongsTo(Employee::class,"employee_id");

    }
    public function branche(){
        return $this->belongsTo(Branch::class,"branch_id");

    }
    public function deptureBranche(){
        return $this->belongsTo(Branch::class,"depture_branche_id");

    }


    // public function getLogoAttribute($value)
    // {
    //     return  asset('public/' . Attendance::UPLOADED_FILES . "/" . $value);
    // }
}
