<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class AutoShift extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'branch_id',
        'days',
        'status',
    ];

    protected $casts = [
        'days' => 'array',
        'status' => 'boolean',
    ];

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function autoShiftDetails()
    {
        return $this->hasMany(AutoShiftDetails::class);
    }

    public function scopeActive(Builder $query, bool $status = true): void
    {
        $query->where('status', $status);
    }
}
