<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BillExpense extends Model
{
    use HasFactory;

    protected $fillable = [
        'bill_id',
        'expense_id',
        'amount',
    ];

    public function bill()
    {
        return $this->belongsTo(Bill::class);
    }

    public function expense()
    {
        return $this->belongsTo(Expense::class);
    }

    public function getAmountAttribute($value)
    {
        return $value / 100;
    }

    public function setAmountAttribute($value)
    {
        $this->attributes['amount'] = $value * 100;
    }
}
