<?php

namespace App\Models;

use App\Http\Resources\EmployeeResource;
use App\Http\Services\Account\AccountService;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class Employee extends Authenticatable
{
    use HasFactory, HasTranslations, SoftDeletes, HasRoles, HasApiTokens, Notifiable;

    const RULES = [
        'name' => 'nullable',
        'name_ar' => 'required',
        'name_en' => 'nullable',
        'birth_date' => 'nullable|date',
        'identity_type' => 'nullable|integer',
        'ID_number' => 'nullable|string',
        'hiring_date' => 'nullable|date',
        'status' => 'nullable|boolean',
        'online' => 'nullable|boolean',
        'calendar_appearance' => 'nullable|boolean',
        'attendance_method_id' => 'nullable|exists:attendance_methods,id',
        'section_id' => 'nullable|exists:careers_sections,id',
        'career_id' => 'nullable|exists:careers_sections,id',
        'branch_id' => 'nullable|exists:branches,id',
    ];

    const PASSWORD = 'password';

    protected $fillable = [
        'company_id',
        'name',
        'code',
        'phone',
        'email',
        'birth_date',
        'identity_type',
        'ID_number',
        'hiring_date',
        'status',
        'online',
        'calendar_appearance',
        'attendance_method_id',
        'section_id',
        'career_id',
        'address_id',
        'branch_id',
        'password',
        'worker_id',
        'fcm',
        'pos'
    ];

    protected $translatable = [
        'name',
    ];

    public function shifts()
    {
        return $this->hasMany(Shift::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function journals()
    {
        return $this->hasMany(Journal::class);
    }
    public function attendances()
    {
        return $this->hasMany(Attendance::class, "employee_id");
    }
    public function vactions()
    {
        return $this->hasMany(VacationRequest::class);
    }

    public function worker()
    {
        return $this->hasOne(Worker::class);
    }

    public function absences()
    {
        return $this->hasMany(Absence::class);
    }

    // public function vacations()
    // {
    //     return $this->hasMany(VacationRequest::class, 'employee_id');
    // }

    public function vacationsRequests()
    {
        return $this->hasMany(VacationRequest::class, 'employee_id');
    }

    public function attendanceMethod()
    {
        return $this->belongsTo(AttendanceMethod::class);
    }

    public function section()
    {
        return $this->belongsTo(Section::class)->where('type', Section::SECTION_TYPE);
    }

    public function career()
    {
        return $this->belongsTo(Career::class)->where('type', Career::CAREER_TYPE);
    }

    // public function branch()
    // {
    //     return $this->belongsTo(Branch::class);
    // }

    public function branches()
    {
        return $this->belongsToMany(Branch::class, "branche_employee", 'employee_id', 'branch_id');
    }

    public function address()
    {
        return $this->belongsTo(Address::class);
    }

    public function employeeTransactions()
    {
        return $this->hasMany(EmployeeTransaction::class);
    }

    public function delivery()
    {
        return $this->hasMany(Delivery::class);
    }
    public function custodyTaken()
    {
        return $this->hasMany(CustodyTaken::class);
    }
    public function custody()
    {
        return $this->hasOne(Custody::class);
    }

    public function account()
    {
        return $this->hasOneThrough(Account::class, Custody::class, 'employee_id', 'id', 'id', 'account_id');
    }

    public function resolveResource()
    {
        return EmployeeResource::class;
    }
}
