<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmployeeTransaction extends Model
{
    use HasFactory;

    protected $table = 'employee_transaction';

    const RULES = [
        'employee_id' => 'required|exists:employees,id',
        'from_branch_id' => 'required|exists:branches,id',
        'to_branch_id' => 'required|exists:branches,id',
        'temporary' => 'required|boolean',
        'end_date' => 'required_if:temporary,true',
    ];

    protected $fillable = [
        'company_id',
        'employee_id',
        'from_branch_id',
        'to_branch_id',
        'temporary',
        'end_date',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    public function fromBranch()
    {
        return $this->belongsTo(Branch::class, 'from_branch_id');
    }

    public function toBranch()
    {
        return $this->belongsTo(Branch::class, 'to_branch_id');
    }
}
