<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;

class Expense extends Model
{
    use HasFactory, HasTranslations;

    protected $fillable = [
        'name',
        'company_id',
        'account_id',
    ];

    protected $translatable = [
        'name',
    ];

    public function account()
    {
        return $this->belongsTo(Account::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function billExpenses()
    {
        return $this->hasMany(BillExpense::class);
    }
}
