<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;

class GroupSetting extends Model
{
    use HasFactory, HasTranslations;

    const ROLE = [
        'name' => 'nullable',
        'name_ar' => 'required|string',
        'name_en' => 'required|string',

    ];

    protected $fillable = [
        'name',
        'company_id',
    ];

    protected $translatable = [
        'name',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function subSettings()
    {
        return $this->hasMany(GroupSubSetting::class);
    }

    public function branches()
    {
        return $this->hasMany(Branch::class);
    }
}
