<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InventoryProduct extends Model
{
    use HasFactory;


    protected $guarded = [];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
    public function inventory()
    {
        return $this->belongsTo(Inventory::class);
    }
    public function productWarehouse()
    {
        return $this->hasOne(ProductWarehouse::class, 'product_id', 'product_id')
                    ->where('warehouse_id', $this->inventory->warehouse->id);
    }

    public function getProductQuantity()
    {
        return $this->productWarehouse ? $this->productWarehouse->quantity : 0;
    }
}
