<?php

namespace App\Models;

use App\Observers\JournalEntryObserver;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;


#[ObservedBy([JournalEntryObserver::class])]
class JournalEntry extends Model
{
    use HasFactory;

    protected $fillable = [
        'journal_id', // main transaction
        'status', // (debit - credit)
        'account_id',
        'type_type', // ex: supplier class
        'type_id', // ex: supplier id
        'amount', // amount of this close ( بند )
        'old_account_amount',
        'note',
        'order',
    ];
    protected $with = ['journal'];
    public function journal()
    {
        return $this->belongsTo(Journal::class);
    }

    public function account()
    {
        return $this->belongsTo(Account::class);
    }

    public function type()
    {
        return $this->morphTo('type');
    }

    public function setAmountAttribute($value)
    {
        $this->attributes['amount'] = $value * 100;
    }

    public function getAmountAttribute($value)
    {
        return $value / 100;
    }

    public function setOldAccountAmountAttribute($value)
    {
        $this->attributes['old_account_amount'] = $value * 100;
    }

    public function getOldAccountAmountAttribute($value)
    {
        return $value / 100;
    }
}
