<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JournalFile extends Model
{
    use HasFactory;

    protected $fillable = ['journal_id', 'file', 'reference_number'];

    public function journal()
    {
        return $this->belongsTo(Journal::class);
    }
    
    public function getFileAttribute($value)
    {
        return $value 
            ? asset('public/' . Journal::UPLOADED_FILES . '/' . $value) 
            : null;
    }
}
