<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JournalReptation extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function journal()
    {
        return $this->belongsTo(Journal::class, 'journal_id')->with('entries.account');
    }
    public function notifications()
    {
        return $this->hasMany(JournalRepeationNotification::class, 'journal_repeation_id');
    }
}
