<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;

class Location extends Model
{
    use HasFactory, SoftDeletes, HasTranslations;

    protected $fillable = [
        'parent_id',
        'name',
        'code',
    ];

    protected $translatable = [
        'name',
    ];

    public function parent()
    {
        return $this->belongsTo(self::class, 'parent_id');
    }

    public function children()
    {
        return $this->hasMany(self::class, 'parent_id');
    }

    public function cities()
    {
        return $this->children();
    }

    public function areas()
    {
        return $this->cities()->children();
    }

    public function city()
    {
        return $this->parent();
    }

    public function country()
    {
        return $this->parent();
    }
}
