<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;

class MainModel extends Model
{
    use HasFactory, HasTranslations;

    protected $fillable = ['name', 'label'];
    protected $translatable = ['label'];

    public function accounts()
    {
        return $this->belongsToMany(Account::class, 'account_model_group', 'model_id', 'account_id')
            ->withPivot('group_id', 'company_id');
    }

    public function modelGroups()
    {
        return $this->belongsToMany(ModelGroup::class)->withPivot('type');
    }
}
