<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;

class MainSellNature extends Model
{
    use HasFactory, SoftDeletes, HasTranslations;

    protected $fillable = [
        'name',
        'rule',
        'model',
        'resource'
    ];

    protected $translatable = [
        'name',
    ];

    protected $casts = [
        'rule' => 'json',
    ];

    public function companies()
    {
        return $this->belongsToMany(Company::class , 'company_main_sell_nature')->withPivot('label');
    }
}
