<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Http\Enums\Order\OrderStatusEnum;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Order extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'ref_id',
        'bill_type',
        'note',
        'total',
        'subtotal',
        'tax',
        'discount',
        'user_id',
        'cart_id',
        'status',
        'paid_amount',
    ];

    public $casts = [
        'status' => OrderStatusEnum::class,
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function user()
    {
        return $this->hasOne(OrderUser::class);
    }

    public function items()
    {
        return $this->hasMany(ItemOrder::class);
    }

    public function getTotalAttribute($value)
    {
        return number_format($value / 100, 2);
    }

    public function setTotalAttribute($value)
    {
        $this->attributes['total'] = $value * 100;
    }

    public function getPaidAmountAttribute($value)
    {
        return number_format($value / 100, 2);
    }

    public function setPaidAmountAttribute($value)
    {
        $this->attributes['paid_amount'] = $value * 100;
    }

    public function getTaxAttribute($value)
    {
        return number_format($value / 100, 2);
    }

    public function setTaxAttribute($value)
    {
        $this->attributes['tax'] = $value * 100;
    }

    public function getDiscountAttribute($value)
    {
        return number_format($value / 100, 2);
    }

    public function setDiscountAttribute($value)
    {
        $this->attributes['discount'] = $value * 100;
    }

    public function getSubtotalAttribute($value)
    {
        return number_format($value / 100, 2);
    }

    public function setSubtotalAttribute($value)
    {
        $this->attributes['subtotal'] = $value * 100;
    }
}
