<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use App\Http\Enums\Package\PackageTypeEnum;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Package extends Model
{
    use HasFactory, SoftDeletes, HasTranslations;

    protected $fillable = [
        'name',
        'price',
        'type',
        // 'branches',
        // 'workers',
        'status',
        'free',
        'period', // in days
    ];

    protected $translatable = [
        'name',
    ];

    protected $casts = [
        'type' => PackageTypeEnum::class,
    ];

    public function subscriptions()
    {
        return $this->hasMany(Subscription::class);
    }

    public function features()
    {
        return $this->belongsToMany(Feature::class)->withPivot('value');
    }

    public function scopeActive($query, $status = 1)
    {
        return $query->where('status', $status);
    }

    public function getPriceAttribute($value)
    {
        return $value / 100;
    }

    public function setPriceAttribute($value)
    {
        $this->attributes['price'] = $value * 100;
    }

    public static function freePackage()
    {
        return self::free()->first();
    }

    public function scopeFree($query)
    {
        return $query->where('free', 1);
    }
}
