<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class PermissionRequest extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'employee_id',
        // 'vacation_id',
        // 'substitute_employee_id',
        'from',
        'to',
        'note',
        // 'status',
    ];

    const RULES = [
        'from' => 'required|date',
        'to' => 'required|date|after_or_equal:from',
        'note' => 'nullable|string',
    ];


    protected $dates = ['from', 'to'];

    public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id');
    }
}
