<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class ProductBranch extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'branche_id',
        'product_id',
        'min_quantity',
        'max_quantity',
        'value',
        'price',
        'quantity',
        'open_balance_price',
        'open_balance_quantity',
    ];

    const RULES = [
      

        'branch_unit' => 'nullable|array',
        'branch_unit.*.branche_id' => 'required|exists:branches,id|distinct',
        'branch_unit.*.min_quantity' => 'nullable|numeric',
        'branch_unit.*.max_quantity' => 'nullable|numeric',
        'branch_unit.*.units' => 'required|array|min:1',
        'branch_unit.*.units.*.unit_id' => 'required|exists:company_units,id',
        'branch_unit.*.units.*.purchasing_price' => 'required|numeric|min:0',
        'branch_unit.*.units.*.selling_price' => 'required|numeric|min:0',
    ];

    public function branch()
    {
        return $this->belongsTo(Branch::class,"branche_id");
    }

    public function productQuantityTracks()
    {
        return $this->hasMany(ProductQuantityTrack::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function unit()
    {
        return $this->belongsTo(CompanyUnit::class, 'unit_id');
    }

    public function branchUnits()
    {
        return $this->hasMany(BranchUnit::class);
    }

    public function journals()
    {
        return $this->morphMany(Journal::class, 'journalable');
    }

    public function getPriceAttribute($value)
    {
        return $value / 100;
    }

    public function setPriceAttribute($value)
    {
        $this->attributes['price'] = $value * 100;
    }

    public function getOpenBalancePriceAttribute($value)
    {
        return $value / 100;
    }

    public function setOpenBalancePriceAttribute($value)
    {
        $this->attributes['open_balance_price'] = $value * 100;
    }

    public function getValueAttribute($value)
    {
        return $value / 100;
    }

    public function setValueAttribute($value)
    {
        $this->attributes['value'] = $value * 100;
    }
}
