<?php

namespace App\Models;

use App\Models\Category;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Translatable\HasTranslations;

class Service extends Model
{
    use HasFactory, SoftDeletes, HasTranslations;

    const RULES = [
        'category_id' => 'required|exists:categories,id',
        'name' => 'nullable',
        'name_ar' => 'required|string',
        'name_en' => 'nullable|string',
        'description' => 'nullable',
        'description_ar' => 'nullable|string',
        'description_en' => 'nullable|string',
        'fast_service' => 'required|boolean',
        // 'fast_service_id' => 'required_if:fast_service,on|exists:categories,id',
        'second_employee' => 'required|boolean',
        'second_employee_rate' => 'required_if:second_employee,on',
        'time_type_id' => 'nullable',
        'time_amount' => 'nullable',
        'calender_appearance' => 'required|boolean',
        'internet_description' => 'nullable|string',
        'details' => 'nullable|string',
        'status' => 'required|boolean',
        'processing' => 'required|boolean',
        'preparation_min' => 'nullable:processing',
        'finishing_min' => 'nullable:processing',
        'pricing.pricing_type' => 'between:1,3',
        'pricing.price' => 'nullable',
        'pricing.home_price' => 'nullable',
    ];

    protected $fillable = [
        'company_id',
        'code',
        'category_id',
        'name',
        'description',
        'fast_service',
        // 'fast_service_id',
        'second_employee',
        'second_employee_rate',
        'time_type_id',
        'time_amount',
        'calender_appearance',
        'internet_description',
        'details',
        'status',
        'processing',
        'preparation_min',
        'finishing_min',
        'pricing_type',
        'price',
        'home_price',
    ];

    public $translatable = [
        'name',
        'description',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }

    // public function fastServiceCategory()
    // {
    //     return $this->belongsTo(Category::class, 'fast_service_id');
    // }

    public function productServiceUnits()
    {
        return $this->hasMany(ProductServiceUnit::class, 'service_id')->with('product');
    }

    public function billServices()
    {
        return $this->hasMany(BillService::class);
    }

    public function branches()
    {
        return $this->hasMany(ServiceBranch::class);
    }
}
