<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ShipmentItem extends Model
{
    use HasFactory;

    protected $with = ['tax'];

    protected $fillable = [
        'shipment_id',
        'cost',
        'total',
        'weight',
        'tax_id',
        'attachment',
        'notes',
        'item_id',
        'discount_id',
        'discount_type', //number or percentage
        'discount',
    ];

    public function shipment()
    {
        return $this->belongsTo(Shipment::class, 'shipment_id', 'id');
    }
    public function tax()
    {
        return $this->belongsTo(Tax::class);
    }

    public function type()
    {
        return $this->belongsTo(ShipmentItemType::class, 'item_id');
    }
}
