<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Http\Resources\StockTransferResource;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class StockTransfer extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'product_id',
        'from_warehouse',
        'from_branch',
        'to_warehouse',
        'to_branch',
        'quantity',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function fromWarehouse()
    {
        return $this->belongsTo(Warehouse::class, 'from_warehouse', 'id');
    }

    public function toWarehouse()
    {
        return $this->belongsTo(Warehouse::class, 'to_warehouse', 'id');
    }

    public function fromBranch()
    {
        return $this->belongsTo(Branch::class, 'from_branch', 'id');
    }

    public function toBranch()
    {
        return $this->belongsTo(Branch::class, 'to_branch', 'id');
    }

    public function journals()
    {
        return $this->morphMany(Journal::class, 'journalable');
    }
}
