<?php

namespace App\Models;

use App\Http\Helper\AccountHelper;
use Illuminate\Database\Eloquent\Model;
use App\Http\Resources\TreasuryResource;
use Spatie\Translatable\HasTranslations;
use App\Http\Services\Account\AccountService;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Treasury extends Model
{
    use HasFactory, SoftDeletes, HasTranslations;

    const RULES = [
        'name' => 'nullable',
        'name_ar' => 'required|string',
        'name_en' => 'nullable|string',
        'status' => 'required|boolean',
        'account_id' => 'required|exists:accounts,id,status,sub',
    ];
    protected $fillable = [
        'company_id',
        'branch_id',
        'name',
        'status',
        'account_id',
    ];

    protected $translatable = [
        'name',
    ];

    public function shifts()
    {
        return $this->hasMany(Shift::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function resolveResource()
    {
        return TreasuryResource::class;
    }

    public function account()
    {
        return $this->belongsTo(Account::class);
        // return AccountService::getAccountForModel(AccountHelper::ACCOUNT_BANKS);
    }

    public function autoShiftDetails()
    {
        return $this->hasMany(AutoShiftDetails::class);
    }
}
