<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class VacationRequest extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded = [];

    const VACATION_PENDING = 0;
    const VACATION_ACCEPTED = 1;
    const VACATION_REJECTED = 2;

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }
}
